// TimeTester - Stephen Stair 2007 - sgstair@akkit.org
// TimeTester is a simple test framework for measuring speed, comparing results, and testing for routine correctness on the DS.
// template.h: declarations for routines created in template.cpp

/* [MIT License segment]
Copyright (c) 2007 - Stephen Stair (sgstair@akkit.org)

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#ifndef TEMPLATE_H
#define TEMPLATE_H

#include <nds.h>

void pset( int x, int y, u16 color );
void ClearLines( int y1, int y2, u16 color );
void DrawFilledRect( int x1, int y1, int x2, int y2, u16 colorline, u16 colorfill );


void DrawCharacter(int x, int y, int charbase, int width, u16 color);
int GetWidth(const char * string);
int GetFontHeight();
void DrawString(int x, int y, const char * string, u16 color);

void StartTimer();
u64 StopTimer();  // returns number of clock cycles elapsed since StartTimer

void DrawStatusBar(char * text);







#endif

