// TimeTester - Stephen Stair 2007 - sgstair@akkit.org
// TimeTester is a simple test framework for measuring speed, comparing results, and testing for routine correctness on the DS.
// TestTree.h: definitions for the data structures used by TimeTester, and interfaces for adding new tests.

/* [MIT License segment]
Copyright (c) 2007 - Stephen Stair (sgstair@akkit.org)

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#ifndef TESTTREE_H
#define TESTTREE_H

#include <nds.h>
#include <string>
#include <vector>



class TestNode
{
public:
    virtual ~TestNode() {}
    virtual std::string RunTest(bool & passed) = 0;
};

class TestTreeNode
{
public:
    TestTreeNode();

    bool AmSelectedChild();
    int GetRenderHeight();
    int GetSelectedCenterPos();
    int Render(int xpos, int ypos);
    int GetNumElements();
    void EvalMyColor();
    void EvalDownColor();
    void EvalUpColor();
    void RunTests();
    void RunSelectedTest();
    void RunTest(int test);

    std::string testname;
    std::string testtext;
    TestTreeNode * parent;

    u16 panelcolor;

    bool isExpanded;
    int selected_index;
    int startup_refcount;
    int num_tested, num_passed, num_total;

    void (*startupfunc)();
    void (*shutdownfunc)();
    std::vector<TestTreeNode *> subnodes;
    std::vector<TestNode *> tests;
    std::vector<bool> test_passed;
    std::vector<bool> test_run;
    std::vector<std::string> test_name;
    std::vector<std::string> test_result;
};




class TestTree 
{
public:


    static void RegisterTest(TestNode * test, std::string testname, std::string parent);
    static void RegisterCategory(std::string categoryname, std::string categorytext, std::string parent, void (*startup)(), void (*shutdown)() );

    static void RenderTree();
    static void RunTest();
    static void NavDown();
    static void NavUp();
    static void NavLeft();
    static void NavRight();

protected:
    static TestTreeNode * GetExistingCategory(std::string name, TestTreeNode * base=NULL);
    static TestTreeNode * GetNewCategory(std::string name, std::string parent);


    static TestTreeNode root;

};







#endif

